VERSION 5.00
Begin VB.UserControl ucCanvas 
   Alignable       =   -1  'True
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "ucCanvas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'this ucCanvas-Control is used, to encapsulate the Surface-Handling in
'a reusable Container, so that the amount of Code within the Main-Form is reduced
'it also contains the handling of Control-Points, to allow "visual Drag-interaction"...
'...for the slightly more complex examples, which will now follow in this Tutorial
Option Explicit

Event RefreshContents(CC As cCairoContext) 'this will be raised into the hosting Form (e.g. triggered from Mouse-Interaction)

Public Srf As cCairoSurface, CC As cCairoContext 'these two Members are Public (accessible from outside)...
Public ControlPoints As New cControlPoints '...as well as this Container for the Control-Points

'together with the Public-Variables, declared above - this is the only Public Method in our ucCanvas
Public Sub Refresh(Optional ByVal DrawControlPoints As Boolean = True)
  If DrawControlPoints Then ControlPoints.Draw CC
  Srf.DrawToDC UserControl.hDC
End Sub


'------------ All the rest below, is only "delegation-effort" from inside the UserControls Private-Events -------------

'here we just synchronize the Srf-Dimensions to the current Dimensions of the UserControl
Private Sub UserControl_Resize()
  UserControl.ScaleMode = vbPixels
  Set Srf = Cairo.CreateSurface(UserControl.ScaleWidth, UserControl.ScaleHeight)
  Set CC = Srf.CreateContext
  RaiseEvent RefreshContents(CC)
End Sub

'and since our internal Srf already is something like a BackGround-PixelBuffer in the correct Dimensions,
'we do not need to waste even more resources by using the Usercontrols AutoRedraw-mechanism (for flicker-free refreshs)
'we just let the AutoRedraw-Property at False - and actualize the Screen-DC of our UserControl always
'completely, directly from the current Surface-Content in the normally received WM_Paint-Event below
Private Sub UserControl_Paint()
  Srf.DrawToDC UserControl.hDC
End Sub

'the following MouseEvents ensure the Mouse-interaction with our ControlPoints-Container (interactive dragging)
Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim CP As cControlPoint
  Set CP = ControlPoints.CheckControlPointUnderCursor(X, Y)
  If Not CP Is Nothing Then CP.SetMouseDownPoint X, Y: RaiseEvent RefreshContents(CC)
End Sub

Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim CP As cControlPoint, MOverStateChanged As Boolean
  Set CP = ControlPoints.CheckControlPointUnderCursor(X, Y, True, MOverStateChanged)
  If Not CP Is Nothing Or MOverStateChanged Then RaiseEvent RefreshContents(CC)
End Sub

Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  ControlPoints.EnsureMouseUpState
End Sub

